<?php
session_start();
require_once '../config/db.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$token = $data['token'] ?? '';

if (empty($token)) {
    echo json_encode(['success' => false, 'message' => 'No token provided']);
    exit;
}

try {
    // Find the token and check if it's valid and not expired
    $stmt = $pdo->prepare('
        SELECT u.*, r.name as role 
        FROM remember_tokens rt 
        JOIN users u ON rt.user_id = u.id 
        JOIN roles r ON u.role_id = r.id
        WHERE rt.token = ? AND rt.expires_at > NOW()
    ');
    $stmt->execute([$token]);
    $user = $stmt->fetch();

    if ($user) {
        // Check if user is enabled
        if (isset($user['enabled']) && $user['enabled'] == 0) {
            echo json_encode(['success' => false, 'message' => 'Account is disabled']);
            exit;
        }

        // Set session variables
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['role'] = $user['role'];

        // Log successful auto-login
        $stmt = $pdo->prepare('INSERT INTO system_logs (user_id, action, details) VALUES (?, ?, ?)');
        $stmt->execute([$user['id'], 'auto_login', 'User auto-logged in using remember me token']);

        echo json_encode(['success' => true]);
    } else {
        // Token not found or expired, delete it
        $stmt = $pdo->prepare('DELETE FROM remember_tokens WHERE token = ?');
        $stmt->execute([$token]);
        echo json_encode(['success' => false, 'message' => 'Invalid or expired token']);
    }
} catch (PDOException $e) {
    error_log("Token verification error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Database error']);
} 